<?php
/**
 * Action template 3
 *
 * This template can be overridden by copying it to yourtheme/checkout-upsell-woocommerce/action/simple-action-3.php.
 *
 * HOWEVER, on occasion we will need to update template files and you (the theme developer) will need to copy the new files
 * to your theme to maintain compatibility. We try to do this as little as possible, but it does happen.
 */

defined('ABSPATH') || exit;
if (!isset($data)) return;
?>

<div class="cuw-action cuw-template" data-campaign_id="<?php echo esc_attr($data['campaign_id']); ?>"
     style="margin: 12px 0; display: inline-flex; align-items: center; border-radius: 8px; <?php echo esc_attr($data['styles']['template']); ?>">
    <div style="padding: 12px; display: flex; border-radius: 6px 0 0 6px;">
        <input type="checkbox" class="cuw-checkbox cuw-custom-checkbox" <?php if (!empty($data['is_active'])) echo 'checked'; ?>>
    </div>
    <div class="cuw-template-cta-section" style="border-radius: 0 3px 3px 0; padding: 8px; <?php echo esc_attr($data['styles']['cta']); ?>">
        <label style="margin: 0 2px; padding: 2px; cursor: pointer; font-size: inherit; color: inherit; height: 100%;">
            <span class="cuw-template-cta-text"
                  style="font-size: inherit;"><?php echo wp_kses($data['template']['cta_text'], $data['allowed_html']); ?></span>
        </label>
    </div>
</div>