<?php
/**
 * Product addons template 4
 *
 * This template can be overridden by copying it to yourtheme/checkout-upsell-woocommerce/addon/template-4.php.
 *
 * HOWEVER, on occasion we will need to update template files and you (the theme developer) will need to copy the new files
 * to your theme to maintain compatibility. We try to do this as little as possible, but it does happen.
 */

defined('ABSPATH') || exit;
if (!isset($products) || !isset($campaign) || !isset($data)) {
    return;
}

$heading = !empty($data['template']['title']) ? $data['template']['title'] : '';
$addons_price_text = apply_filters('cuw_product_addons_price_text', '');
$total_price_text = apply_filters('cuw_product_addons_total_price_text', esc_html__('Total price', 'checkout-upsell-woocommerce'));
$show_custom_quantity = !empty($campaign['data']['products']['quantity_field']) && $campaign['data']['products']['quantity_field'] == 'custom';
?>

<section class="cuw-product-addons cuw-products cuw-template cuw-mobile-responsive"
         data-campaign_id="<?php echo esc_attr($campaign['id']); ?>"
         data-main_product_regular_price="<?php echo isset($campaign['main_product_regular_price']) ? esc_attr($campaign['main_product_regular_price']) : ''; ?>"
         data-main_product_price="<?php echo isset($campaign['main_product_price']) ? esc_attr($campaign['main_product_price']) : ''; ?>"
         style="margin: 16px 0; <?php echo esc_attr($data['styles']['template']); ?>">
    <input type="hidden" name="cuw_add_to_cart" value="<?php echo esc_attr($campaign['type']); ?>">
    <input type="hidden" name="campaign_id" value="<?php echo esc_attr($campaign['id']); ?>">
    <?php if (isset($heading)) { ?>
        <h4 class="cuw-heading cuw-template-title"
            style="margin-bottom: 10px; <?php echo esc_attr($data['styles']['title']); ?>">
            <?php echo esc_html($heading); ?>
        </h4>
    <?php } ?>
    <div class="cuw-gird" style="display: flex; flex-wrap: wrap; gap: 10px;">
        <?php foreach ($products as $key => $product): ?>
            <div class="cuw-product cuw-product-row <?php echo esc_attr(implode(' ', $product['classes'])); ?>"
                 style="margin-bottom: 20px;"
                 data-id="<?php echo esc_attr($product['id']); ?>"
                 data-regular_price="<?php echo esc_attr($product['regular_price']); ?>"
                 data-price="<?php echo esc_attr($product['price']); ?>">
                <div class="cuw-product-wrapper" style="display: flex;">
                    <div class="cuw-product-container">
                        <div class="cuw-product-card" style="margin: 16px; <?php echo esc_attr($data['styles']['card']); ?>">
                            <div class="cuw-product-image cuw-product-curve-image"
                                 style="box-shadow: none; border-radius: 12px; <?php echo esc_attr($data['styles']['image']); ?>">
                                <?php if (!empty($product['default_variant']['image'])) {
                                    echo wp_kses_post($product['default_variant']['image']);
                                } else {
                                    echo wp_kses_post($product['image']);
                                } ?>
                            </div>
                            <div style="display: flex; margin-top: 10px; align-items: flex-start; gap: 8px;">
                                <div>
                                    <input class="cuw-product-checkbox cuw-custom-checkbox" type="checkbox"
                                           name="products[<?php echo esc_attr($key); ?>][id]"
                                           value="<?php echo esc_attr($product['id']); ?>"
                                           style="margin: 4px;">
                                    <?php if (!empty($product['is_variable']) && !empty($product['variants'])) { ?>
                                        <input class="cuw-product-variation-id" type="hidden"
                                               name="products[<?php echo esc_attr($key); ?>][variation_id]"
                                               value="<?php echo esc_attr(current($product['variants'])['id']); ?>">
                                    <?php } ?>
                                </div>
                                <div class="cuw-product-title">
                                    <?php echo !empty($product['is_main']) ? esc_html(wp_strip_all_tags($product['title'])) : wp_kses_post($product['title']); ?>
                                </div>
                            </div>
                            <?php if (!empty($product['price_html'])): ?>
                                <div class="cuw-product-price">
                                    <?php echo wp_kses_post($product['price_html']); ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($show_custom_quantity) { ?>
                                <div class="cuw-product-quantity" style="zoom: 90%; display: none;">
                                    <?php echo apply_filters('cuw_product_template_quantity', '', $product, ['name' => 'products[' . $key . '][qty]']); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                </div>
                            <?php } ?>
                        </div>
                        <?php if (isset($product['variants']) && !empty($product['variants'])) { ?>
                            <div class="cuw-product-card cuw-product-variants" style="zoom: 90%; width: 80%; justify-content: start; display: none;<?php echo esc_attr($data['styles']['card']); ?>">
                                <div class="cuw-product-variants" >
                                    <?php
                                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                    echo apply_filters('cuw_product_addons_template_product_variants', '', $product, [
                                        'variant_select_name' => 'products[' . esc_attr($key) . '][variation_id]',
                                        'attribute_select_name' => 'products[' . esc_attr($key) . '][variation_attributes]',
                                    ]); ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="cuw-product-addons-pricing-section"
         style="display: none; flex-wrap: wrap; flex-direction: column; gap: 4px; margin-top: 12px;">
        <?php if (!empty($addons_price_text)) { ?>
            <div style="display: flex; justify-content: space-between;">
                <span style="font-weight: bold; font-size: 110%;"><?php echo esc_html($addons_price_text); ?></span>
                <span class="cuw-addons-price" style="font-weight: bold; font-size: 110%;"></span>
            </div>
        <?php } ?>
        <?php if (!empty($total_price_text)) { ?>
            <div class="cuw-total-price-section" style="display: flex; justify-content: space-between;">
                <span style="font-weight: bold; font-size: 110%;"><?php echo esc_html($total_price_text); ?></span>
                <span class="cuw-total-price" style="font-weight: bold; font-size: 110%;"></span>
            </div>
        <?php } ?>
    </div>
</section>
