<?php
/**
 * Product recommendations template 1
 *
 * This template can be overridden by copying it to yourtheme/product-recommendations/template-1.php.
 *
 * HOWEVER, on occasion we will need to update template files and you (the theme developer) will need to copy the new files
 * to your theme to maintain compatibility. We try to do this as little as possible, but it does happen.
 */

defined('ABSPATH') || exit;
if (!isset($data) || !isset($products) || !isset($campaign)) {
    return;
}

$heading = !empty($data['template']['title']) ? $data['template']['title'] : __('You may also like…', 'checkout-upsell-woocommerce');
$heading = apply_filters('cuw_products_template_heading', $heading, $campaign);
$cta_text = !empty($data['template']['cta_text']) ? $data['template']['cta_text'] : __('Add to cart', 'checkout-upsell-woocommerce');
?>

<section class="cuw-upsell-products cuw-products cuw-template cuw-mobile-responsive"
         data-campaign_id="<?php echo esc_attr($campaign['id']); ?>"
         data-page="<?php echo !empty($campaign['data']['page']) ? esc_attr($campaign['data']['page']) : ''; ?>"
         style="margin: 16px 0; <?php echo esc_attr($data['styles']['template']); ?>">
    <?php if (!empty($heading)) : ?>
        <h2 class="cuw-heading cuw-template-title" style="margin-bottom: 20px; <?php echo esc_attr($data['styles']['title']); ?>">
            <?php echo wp_kses_post($heading); ?>
        </h2>
    <?php endif; ?>

    <div class="cuw-grid" style="display: flex; flex-wrap: wrap; gap: 24px;">
        <?php foreach ($products as $key => $product) : ?>
            <?php
            $regular_price = !empty($product['default_variant']) ? $product['default_variant']['regular_price'] : $product['regular_price'];
            $price = !empty($product['default_variant']) ? $product['default_variant']['price'] : $product['price'];
            ?>
            <div class="cuw-product cuw-column cuw-product-row cuw-recommendation-product <?php echo esc_attr(implode(' ', $product['classes'])); ?>"
                 data-id="<?php echo esc_attr($product['id']); ?>"
                 data-regular_price="<?php echo esc_attr($regular_price); ?>"
                 data-price="<?php echo esc_attr($price); ?>" >
                <div class="cuw-product-wrapper">
                    <div class="cuw-product-card" style="<?php echo esc_attr($data['styles']['card']); ?>">
                        <div class="cuw-product-image" style="<?php echo esc_attr($data['styles']['image']); ?>">
                            <?php echo !empty($product['default_variant']['image']) ? wp_kses_post($product['default_variant']['image']) : wp_kses_post($product['image']); ?>
                        </div>

                        <div class="cuw-product-title" style="margin-top: 10px; text-align: center;">
                            <?php echo '<a href="' . esc_url($product['url']) . '">' . esc_html(wp_strip_all_tags($product['title'])) . '</a>'; ?>
                        </div>

                        <?php if (!empty($product['price_html'])) : ?>
                            <div class="cuw-product-price" style="text-align: center;">
                                <?php echo !empty($product['default_variant']['price_html']) ? wp_kses_post($product['default_variant']['price_html']) : wp_kses_post($product['price_html']); ?>
                            </div>
                        <?php endif; ?>

                        <div style="display: flex; justify-content: center; align-items: center;">
                            <div class="cuw-product-quantity">
                                <?php echo apply_filters('cuw_product_template_quantity', '', $product, []); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                            </div>
                        </div>

                        <?php if (!empty($product['variants'])) { ?>
                            <div class="cuw-product-variants" style="max-width: 320px;">
                                <?php echo apply_filters('cuw_product_template_variants', '', $product, []); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                            </div>
                        <?php } ?>

                        <div style="display: flex; justify-content:center; margin-top: 10px;">
                            <button type="button"
                                    class="cuw-add-product-to-cart single_add_to_cart_button button cuw-template-cta-button cuw-template-cta-text"
                                    data-product_id="<?php echo esc_attr($product['id']); ?>"
                                    data-redirect_url = "<?php echo esc_url(wc_get_cart_url()); ?>"
                                    style="<?php echo esc_attr($data['styles']['cta']); ?>">
                                <?php echo esc_html($cta_text); ?>
                            </button>
                            <a href="<?php echo esc_url(wc_get_cart_url()); ?>" style="display:none;"
                               class="cuw-redirect-to-cart single_add_to_cart_button button alt">
                                <?php esc_html_e('View cart', 'checkout-upsell-woocommerce'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</section>
